
//: C09:DBConnection2.h
// Domieszka sparametryzowana
#ifndef DBCONNECTION_H
#define DBCONNECTION_H
#include "Database.h"
#include <cassert>
#include <string>
using std::string;

template<class Counter>
class DBConnection : public Database, public Counter {
  DBConnection(const DBConnection&);     // Blokowanie kopiowania
  DBConnection& operator=(const DBConnection&);

protected:
  DBConnection(const string& dbStr) throw(DatabaseError)
  : Database(dbStr) {
    open();
  }
  ~DBConnection() {
    close();
  }
public:
  static DBConnection* create(const string& dbStr)
  throw(DatabaseError) {
    DBConnection* con = new DBConnection(dbStr);
    con->attach();
    assert(con->refCount() == 1);
    return con;
  }
// Pozostae potrzebne funkcjie interakcji z baz danych...
};
#endif // DBCONNECTION2_H ///:~
