
//: C10:BuildBicycles.cpp
//{L} Bicycle
// Wzorzec projektowy Builder
#include <cstddef>
#include <iostream>
#include <map>
#include <vector>
#include "Bicycle.h"
#include "../purge.h"
using namespace std;

// Konstrukcja roweru za porednictwem odpowiedniego Buildera
Bicycle* buildMeABike(
  BicycleTechnician& t, BicycleBuilder* builder) {
  t.setBuilder(builder);
  t.construct();
  Bicycle* b = builder->getProduct();
  cout << "Konstruuje " << builder->getBikeName() << endl;
  return b;
}

int main() {
  // Zamwienie na pewn ilo rowerw
  map <string, size_t> order;
  order["grski"] = 2;
  order["spacerowy"] = 1;
  order["wyczynowy"] = 3;

  // Budowa rowerw
  vector<Bicycle*> bikes;
  BicycleBuilder* m = new MountainBikeBuilder;
  BicycleBuilder* t = new TouringBikeBuilder;
  BicycleBuilder* r = new RacingBikeBuilder;
  BicycleTechnician tech;
  map<string, size_t>::iterator it = order.begin();
  while(it != order.end()) {
    BicycleBuilder* builder;
    if(it->first == "grski")
      builder = m;
    else if(it->first == "spacerowy")
      builder = t;
    else if(it->first == "wyczynowy")
      builder = r;
    for(size_t i = 0; i < it->second; ++i)
      bikes.push_back(buildMeABike(tech, builder));
    ++it;
  }
  delete m;
  delete t;
  delete r;

  // Stan magazynowy
  for(size_t i = 0; i < bikes.size(); ++i)
    cout << "Rower: " << *bikes[i] << endl;
  purge(bikes);
}

/* Wyjcie programu:
Konstruuje RowerGrski
Konstruuje RowerGrski
Konstruuje RowerSpacerowy
Konstruuje RowerWyczynowy
Konstruuje RowerWyczynowy
Konstruuje RowerWyczynowy
Rower: {
  Rama Koo Siedzenie Przerzutka Kierownica Zbatka Amortyzator }
Rower: {
  Rama Koo Siedzenie Przerzutka Kierownica Zbatka Amortyzator }
Rower: {
  Rama Koo Siedzenie Przerzutka Kierownica Zbatka Baganik }
Rower: { Rama Koo Siedzenie Kierownica Zbatka }
Rower: { Rama Koo Siedzenie Kierownica Zbatka }
Rower: { Rama Koo Siedzenie Kierownica Zbatka }
*/ ///:~
