
//: C07:WordList2.cpp
// Ilustracja wykorzystania iteratora istreambuf_iterator i iteratorw wstawiania
#include <cstring>
#include <fstream>
#include <iostream>
#include <iterator>
#include <locale>
#include <set>
#include <string>
#include "../require.h"
using namespace std;

int main(int argc, char* argv[]) {
  locale loc("Polish_poland");
  char* fname = "WordList2.cpp";
  if(argc > 1) fname = argv[1];
  ifstream in(fname);
  assure(in, fname);
  istreambuf_iterator<char> p(in), end;
  set<string> wordlist;
  while(p != end) {
    string word;
    insert_iterator<string>
      ii(word, word.begin());
    // Wyszukanie pierwszej litery:
    while(!isalpha(*p, loc) && p != end)
      p++;
    // Kopiowanie a do pierwszego znaku niebdcego liter:
    while(isalpha(*p, loc) && p != end)
      *ii++ = *p++;
    if(word.size() != 0)
      wordlist.insert(word);
  }
  // Wyprowadzenie wynikw:
  copy(wordlist.begin(), wordlist.end(),
    ostream_iterator<string>(cout, "\n"));
} ///:~
