
//: C07:Valarray1.cpp
//{-bor}
// Ilustracja dziaania podstawowych funkcji kontenera valarray
#include "PrintValarray.h"
using namespace std;

double f(double x) {
  return 2.0 * x - 1.0;
}

int main() {
  double n[] = {1.0, 2.0, 3.0, 4.0};
  valarray<double> v(n, sizeof n / sizeof n[0]);
  print("v", v);
  valarray<double> sh(v.shift(1));
  print("przesunicie w lewo", sh);
  valarray<double> acc(v + sh);
  print("suma", acc);
  valarray<double> trig(sin(v) + cos(acc));
  print("funkcje trygonometryczne", trig);
  valarray<double> p(pow(v, 3.0));
  print("trzecia potga", p);
  valarray<double> app(v.apply(f));
  print("f(v)", app);
  valarray<bool> eq(v == app);
  print("v == app?", eq);
  double x = v.min();
  double y = v.max();
  double z = v.sum();
  cout << "x = " << x << ", y = " << y
    << ", z = " << z  << endl;
} ///:~
