
//: C07:PriorityQueue7.cpp
// Kolejka priorytetowa generujca wektor
#include <algorithm>
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <iterator>
#include <queue>
#include <vector>
using namespace std;

template<class T, class Compare>
class PQV {
  vector<T> v;
  Compare comp;
public:
  // Nie ma potrzeby wyywoywania algorytmu make_heap()  kontener jest pusty:
  PQV(Compare cmp = Compare()) : comp(cmp) {}
  void push(const T& x) {
    // Umieszczenie elementu na kocu kontenera:
    v.push_back(x);
    // Uporzadkowanie elementu w stercie:
    push_heap(v.begin(), v.end(), comp);
  }
  void pop() {
    // Przesunicie elementu na koniec kontenera:
    pop_heap(v.begin(), v.end(), comp);
    // Usunicie ostatniego elementu:
    v.pop_back();
  }
  const T& top() { return v.front(); }
  bool empty() const { return v.empty(); }
  int size() const { return v.size(); }
  typedef vector<T> TVec;
  TVec getVector() {
    TVec r(v.begin(), v.end());
    // Kontener jest stert
    sort_heap(r.begin(), r.end(), comp);
    // Uporzdkowanie zgodne z priorytetami (od najwikszego):
    reverse(r.begin(), r.end());
    return r;
  }
};

int main() {
  PQV<int, less<int> > pqi;
  srand(time(0));
  for(int i = 0; i < 100; i++)
    pqi.push(rand() % 25);
  const vector<int>& v = pqi.getVector();
  copy(v.begin(), v.end(),
    ostream_iterator<int>(cout, " "));
  cout << "\n-----------\n";
  while(!pqi.empty()) {
    cout << pqi.top() << ' ';
    pqi.pop();
  }
} ///:~
