
//: C07:MultiSet1.cpp
// Demonstracja dziaania kontenera multiset
#include <algorithm>
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <iterator>
#include <set>
using namespace std;

class X {
  char c; // Podstawa porwnania
  int i; // Stan wewntrzny
  // Nie potrzebuje konstruktora domylnego ani operatora przypisania
  X();
  X& operator=(const X&);
  // Zwykle konstruktor kopiujacy jest potrzebny, ale w tym
  // przykadzie dziaa jego wersja syntetyzowana
public:
  X(char cc, int ii) : c(cc), i(ii) {}
  // Operator porwnania operator== nie jest wymagany
  friend bool operator<(const X& x, const X& y) {
    return x.c < y.c;
  }
  friend ostream& operator<<(ostream& os, X x) {
    return os << x.c << ":" << x.i;
  }
};

class Xgen {
  static int i;
  // Liczba znakw zakresu losowego:
  enum { SPAN = 6 };
public:
  X operator()() {
    char c = 'A' + rand() % SPAN;
    return X(c, i++);
  }
};

int Xgen::i = 0;

typedef multiset<X> Xmset;
typedef Xmset::const_iterator Xmit;

int main() {
  Xmset mset;
  // Wypenienie kontenera multiset obiektami X:
  srand(time(0));  // Losowo
  generate_n(inserter(mset, mset.begin()),
    25, Xgen());
   // Inicjalizacja kontenera set na podstawie zawartoci mset:
  set<X> unique(mset.begin(), mset.end());
  copy(unique.begin(), unique.end(),
    ostream_iterator<X>(cout, " "));
  cout << "\n----\n";
  // Iterowanie wrd wartoci niepowtarzajcych si:
  for(set<X>::iterator i = unique.begin();
      i != unique.end(); i++) {
    pair<Xmit, Xmit> p = mset.equal_range(*i);
    copy(p.first, p.second,
      ostream_iterator<X>(cout, " "));
    cout << endl;
  }
} ///:~
