
//: C06:MergeTest.cpp
// Test czenia posortowanych zakresw
#include <algorithm>
#include "PrintSequence.h"
#include "Generators.h"
using namespace std;

int main() {
  const int sz = 15;
  int a[sz*2] = {0};
  // Oba zakresy znajduj si fizycznie w tej samej tablicy:
  generate(a, a + sz, SkipGen(0, 2));
  a[3] = 4;
  a[4] = 4;
  generate(a + sz, a + sz*2, SkipGen(1, 3));
  print(a, a + sz, "zakres 1", " ");
  print(a + sz, a + sz*2, "zakres 2", " ");
  int b[sz*2] = {0}; // Inicjalizacja zerem
  merge(a, a + sz, a + sz, a + sz*2, b);
  print(b, b + sz*2, "merge", " ");
  // Wyzerowanie tablicy b
  for(int i = 0; i < sz*2; i++)
    b[i] = 0;
  inplace_merge(a, a + sz, a + sz*2);
  print(a, a + sz*2, "inplace_merge", " ");
  int* end = set_union(a, a + sz, a + sz, a + sz*2, b);
  print(b, end, "set_union", " ");
} ///:~
