
//: C01:Auto_ptr.cpp
// Pokazuje struktur RAII szablonu auto_ptr
#include <memory>
#include <iostream>
#include <cstddef> 
using namespace std;

class TraceHeap {
  int i;
public:
  static void* operator new(size_t siz) {
    void* p = ::operator new(siz);
    cout << "Alokacja na stercie obiektu TraceHeap "
         << "pod adresem " << p << endl;
    return p;
  }
  static void operator delete(void* p) {
    cout << "Usuwanie obiektu TraceHeap spod adresu "
         << p << endl;
    ::operator delete(p);
  }
  TraceHeap(int i) : i(i) {}
  int getVal() const {
    return i;
  }
};

int main() {
  auto_ptr<TraceHeap> pMyObject(new TraceHeap(5));
  cout << pMyObject->getVal() << endl;  // prints 5
} ///:~
