
//: C09:Paste.cpp
//{L} Vendor
// Uzupenienie brakw biblioteki z wykorzystaniem wielodziedziczenia
#include <iostream>
#include "Vendor.h"
using namespace std;

class MyBase { // Uzupenienie pierwotnego interfejsu
public:
  virtual void v() const = 0;
  virtual void f() const = 0;
  // Nowe wywoanie interfejsu:
  virtual void g() const = 0;
  virtual ~MyBase() { cout << "~MyBase()\n"; }
};

class Paste1 : public MyBase, public Vendor1 {
public:
  void v() const {
    cout << "Paste1::v()\n";
    Vendor1::v();
  }
  void f() const {
    cout << "Paste1::f()\n";
    Vendor1::f();
  }
  void g() const {
    cout << "Paste1::g()\n";
  }
  ~Paste1() { cout << "~Paste1()\n"; }
};

int main() {
  Paste1& p1p = *new Paste1;
  MyBase& mp = p1p; // Rzutowanie w gr hierarchii
  cout << "wywoanie f()\n";
  mp.f();  // Poprawne dziaanie
  cout << "wywoanie g()\n";
  mp.g(); // Nowe wywoanie
  cout << "wywoanie A(p1p)\n";
  A(p1p); // Pierwotne dziaanie
  cout << "wywoanie B(p1p)\n";
  B(p1p);  // Pierwotne dziaanie
  cout << "usunicie mp\n";
  // Zwolnienie referencji do obiektu:
  delete &mp; // Poprawne dziaanie
} ///:~
