
//: C05:ApplySequence.h
// Stosuje funkcj do kontenera sekwencyjnego STL

// const, 0 argumentw, warto zwracana dowolnego typu
template<class Seq, class T, class R>
void apply(Seq& sq, R (T::*f)() const) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end()) 
    ((*it++)->*f)();
}

// const, 1 argumentw, warto zwracana dowolnego typu
template<class Seq, class T, class R, class A>
void apply(Seq& sq, R(T::*f)(A) const, A a) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end())
    ((*it++)->*f)(a);
}

// const, 2 argumenty, warto zwracana dowolnego typu
template<class Seq, class T, class R,
         class A1, class A2>
void apply(Seq& sq, R(T::*f)(A1, A2) const,
    A1 a1, A2 a2) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end()) 
     ((*it++)->*f)(a1, a2);
}
// nie const, 0 argumentw, warto zwracana dowolnego typu
template<class Seq, class T, class R>
void apply(Seq& sq, R (T::*f)()) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end())
    ((*it++)->*f)();
}

// nie const, 1 argument, warto zwracana dowolnego typu
template<class Seq, class T, class R, class A>
void apply(Seq& sq, R(T::*f)(A), A a) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end())
    ((*it++)->*f)(a);
}

// nie const, 2 argumenty, warto zwracana dowolnego typu
template<class Seq, class T, class R,
         class A1, class A2>
void apply(Seq& sq, R(T::*f)(A1, A2),
    A1 a1, A2 a2) {
  typename Seq::iterator it = sq.begin();
  while(it != sq.end())
    ((*it++)->*f)(a1, a2);
}
// Itd., aby obsuy najbardziej prawdopodobne argumenty ///:~
