
//: C01:SafeAssign.cpp
// Pokazuje funkcj operator= bezpieczn z punktu widzenia wyjtkw
#include <iostream>
#include <new>       // z uwagi na std::bad_alloc
#include <cstring>
#include <cstddef> 
using namespace std;

// Klasa z dwoma wskanikami korzystajca ze sterty
class HasPointers {
  // Klasa-uchwyt na dane
  struct MyData {
    const char* theString;
    const int* theInts;
    size_t numInts;
    MyData(const char* pString, const int* pInts,
           size_t nInts)
    : theString(pString), theInts(pInts),
    numInts(nInts) {}
  } *theData;  // uchwyt

  // funkcje clone i cleanup
  static MyData* clone(const char* otherString,
                       const int* otherInts, size_t nInts){
    char* newChars = new char[strlen(otherString)+1];
    int* newInts;
    try {
      newInts = new int[nInts];
    } catch (bad_alloc&) {
      delete [] newChars;
      throw;
    }
    try {
      // W przykadzie tym wykorzystywane s typy wbudowane,
      // wic nie bd one wyrzucay adnych wyjtkw. Jednak
      // jeli uyte byyby klasy, mogyby one wyrzuca 
      // wyjtki, wobec czego uyto w celach dydaktycznych
      // bloku try (o to wanie chodzi w tym przykadzie!)
      strcpy(newChars, otherString);
      for (size_t i = 0; i < nInts; ++i)
        newInts[i] = otherInts[i];
    } catch (...) {
      delete [] newInts;
      delete [] newChars;
      throw;
    }
    return new MyData(newChars, newInts, nInts);
  }
  static MyData* clone(const MyData* otherData) {
    return clone(otherData->theString,
                 otherData->theInts,
                 otherData->numInts);
  }
  static void cleanup(const MyData* theData) {
    delete [] theData->theString;
    delete [] theData->theInts;
    delete theData;
  }
public:
  HasPointers(const char* someString, const int* someInts,
              size_t numInts) {
    theData = clone(someString, someInts, numInts);
  }
  HasPointers(const HasPointers& source) {
    theData = clone(source.theData);
  }
  HasPointers& operator=(const HasPointers& rhs) {
    if (this != &rhs) {
      MyData* newData =
      clone(rhs.theData->theString,
            rhs.theData->theInts,
            rhs.theData->numInts);
      cleanup(theData);
      theData = newData;
    }
    return *this;
  }
  ~HasPointers() {
    cleanup(theData);
  }
  friend ostream& operator<<(ostream& os,
                             const HasPointers& obj) {
    os << obj.theData->theString << ": ";
    for (size_t i = 0; i < obj.theData->numInts; ++i)
      os << obj.theData->theInts[i] << ' ';
    return os;
  }
};

int main() {
  int someNums[] = {1, 2, 3, 4};
  size_t someCount = sizeof someNums / sizeof someNums[0];
  int someMoreNums[] = {5, 6, 7};
  size_t someMoreCount =
  sizeof someMoreNums / sizeof someMoreNums[0];
  HasPointers h1("Dzie dobry", someNums, someCount);
  HasPointers h2("Do widzenia", someMoreNums, someMoreCount);
  cout << h1 << endl;  // Dzie dobry: 1 2 3 4
  h1 = h2;
  cout << h1 << endl;  // Do widzenia: 5 6 7
} ///:~
