/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class SafariTechPreviewDriverService
extends DriverService {
    public static final String TP_SAFARI_DRIVER_EXE_PROPERTY = "webdriver.tp.safari.driver";
    private static final File TP_SAFARI_DRIVER_EXECUTABLE = new File("/Applications/Safari Technology Preview.app/Contents/MacOS/safaridriver");

    public SafariTechPreviewDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public SafariTechPreviewDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static SafariTechPreviewDriverService createDefaultService() {
        return (SafariTechPreviewDriverService)new Builder().build();
    }

    @Override
    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException(e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariTechPreviewDriverService, Builder> {
        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if ("Safari Technology Preview".equals(capabilities.getBrowserName())) {
                score = 10;
            }
            return score;
        }

        @Override
        protected File findDefaultExecutable() {
            File exe = System.getProperty(SafariTechPreviewDriverService.TP_SAFARI_DRIVER_EXE_PROPERTY) != null ? new File(System.getProperty(SafariTechPreviewDriverService.TP_SAFARI_DRIVER_EXE_PROPERTY)) : TP_SAFARI_DRIVER_EXECUTABLE;
            if (!exe.isFile()) {
                throw new WebDriverException("Unable to find driver executable: " + exe);
            }
            return exe;
        }

        @Override
        protected List<String> createArgs() {
            return Arrays.asList("--port", String.valueOf(this.getPort()));
        }

        @Override
        protected SafariTechPreviewDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new SafariTechPreviewDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

