/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class AddToSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final Json json;
    private final SessionMap sessions;

    AddToSessionMap(Tracer tracer, Json json, SessionMap sessions) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.json = Require.nonNull("Json converter", json);
        this.sessions = Require.nonNull("Session map", sessions);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessions.add_session");){
            Tags.HTTP_REQUEST.accept(span, req);
            Session session = (Session)this.json.toType(Contents.string(req), (Type)((Object)Session.class));
            Objects.requireNonNull(session, "Session to add must be set");
            RemoteTags.SESSION_ID.accept(span, session.getId());
            RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
            span.setAttribute("session.uri", session.getUri().toString());
            this.sessions.add(session);
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setContent((Supplier)Contents.asJson(ImmutableMap.of("value", true)));
            return httpResponse;
        }
    }
}

