/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.DefaultSlotMatcher;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class Slot
implements Serializable {
    private final SlotId id;
    private final Capabilities stereotype;
    private final Session session;
    private final Instant lastStarted;
    private final SlotMatcher slotMatcher;

    public Slot(SlotId id, Capabilities stereotype, Instant lastStarted, Session session) {
        this.id = Require.nonNull("Slot ID", id);
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
        this.lastStarted = Require.nonNull("Last started", lastStarted);
        this.session = session;
        this.slotMatcher = new DefaultSlotMatcher();
    }

    private static Slot fromJson(JsonInput input) {
        SlotId id = null;
        Capabilities stereotype = null;
        Instant lastStarted = null;
        Session session = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            String name;
            switch (name = input.nextName()) {
                case "id": {
                    id = (SlotId)input.read((Type)((Object)SlotId.class));
                    continue block12;
                }
                case "lastStarted": {
                    lastStarted = (Instant)input.read((Type)((Object)Instant.class));
                    continue block12;
                }
                case "session": {
                    session = (Session)input.read((Type)((Object)Session.class));
                    continue block12;
                }
                case "stereotype": {
                    stereotype = (Capabilities)input.read((Type)((Object)Capabilities.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Slot(id, stereotype, lastStarted, session);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Serializable> toReturn = new TreeMap<String, Serializable>();
        toReturn.put("id", this.getId());
        toReturn.put("lastStarted", this.getLastStarted());
        toReturn.put("session", this.getSession());
        toReturn.put("stereotype", this.getStereotype());
        return Collections.unmodifiableMap(toReturn);
    }

    public SlotId getId() {
        return this.id;
    }

    public Capabilities getStereotype() {
        return this.stereotype;
    }

    public Instant getLastStarted() {
        return this.lastStarted;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isSupporting(Capabilities caps) {
        return this.slotMatcher.matches(this.getStereotype(), caps);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slot)) {
            return false;
        }
        Slot that = (Slot)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.stereotype, that.stereotype) && Objects.equals(this.session, that.session) && Objects.equals(this.lastStarted.toEpochMilli(), that.lastStarted.toEpochMilli());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stereotype, this.session, this.lastStarted.toEpochMilli());
    }
}

