/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.data.LogDataImpl;
import io.opentelemetry.sdk.logs.data.Severity;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class LogDataBuilder {
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private long epochNanos;
    private SpanContext spanContext = SpanContext.getInvalid();
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    @Nullable
    private String name;
    private Body body = Body.empty();
    private final Clock clock;
    private Attributes attributes = Attributes.empty();

    private LogDataBuilder(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Clock clock) {
        this.resource = resource;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.clock = clock;
    }

    public static LogDataBuilder create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return LogDataBuilder.create(resource, instrumentationLibraryInfo, Clock.getDefault());
    }

    public static LogDataBuilder create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Clock clock) {
        return new LogDataBuilder(resource, instrumentationLibraryInfo, clock);
    }

    public LogDataBuilder setEpoch(long timestamp, TimeUnit unit) {
        this.epochNanos = unit.toNanos(timestamp);
        return this;
    }

    public LogDataBuilder setEpoch(Instant instant) {
        this.epochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    public LogDataBuilder setContext(Context context) {
        this.spanContext = Span.fromContext(context).getSpanContext();
        return this;
    }

    public LogDataBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public LogDataBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    public LogDataBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LogDataBuilder setBody(String body) {
        this.body = Body.string(body);
        return this;
    }

    public LogDataBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public LogData build() {
        if (this.epochNanos == 0L) {
            this.epochNanos = this.clock.now();
        }
        return LogDataImpl.create(this.resource, this.instrumentationLibraryInfo, this.epochNanos, this.spanContext, this.severity, this.severityText, this.name, this.body, this.attributes);
    }
}

