/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Field;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class FieldsOnCorrectType
extends AbstractRule {
    public FieldsOnCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (parentType == null) {
            return;
        }
        GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
        if (fieldDef == null) {
            String message = String.format("Field '%s' in type '%s' is undefined", field.getName(), parentType.getName());
            this.addError(ValidationErrorType.FieldUndefined, field.getSourceLocation(), message);
        }
    }
}

