/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import graphql.validation.Validator;
import java.util.ArrayList;
import java.util.List;

@Internal
public class ValidationErrorCollector {
    private final List<ValidationError> errors = new ArrayList<ValidationError>();
    private final int maxErrors;

    public ValidationErrorCollector() {
        this(Validator.MAX_VALIDATION_ERRORS);
    }

    public ValidationErrorCollector(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    private boolean atMaxErrors() {
        return this.errors.size() >= this.maxErrors - 1;
    }

    public void addError(ValidationError validationError) throws MaxValidationErrorsReached {
        if (this.atMaxErrors()) {
            this.errors.add(ValidationError.newValidationError().validationErrorType(ValidationErrorType.MaxValidationErrorsReached).description(String.format("The maximum number of validation errors has been reached. (%d)", this.maxErrors)).build());
            throw new MaxValidationErrorsReached();
        }
        this.errors.add(validationError);
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public boolean containsValidationError(ValidationErrorType validationErrorType) {
        return this.containsValidationError(validationErrorType, null);
    }

    public boolean containsValidationError(ValidationErrorType validationErrorType, String description) {
        for (ValidationError validationError : this.errors) {
            if (validationError.getValidationErrorType() != validationErrorType) continue;
            return description == null || validationError.getDescription().equals(description);
        }
        return false;
    }

    public String toString() {
        return "ValidationErrorCollector{errors=" + this.errors + '}';
    }

    @Internal
    static class MaxValidationErrorsReached
    extends RuntimeException {
        MaxValidationErrorsReached() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

