/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.impl;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeResolvingVisitor;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTraverser;
import graphql.schema.impl.MultiReadOnlyGraphQLTypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Internal
public class SchemaUtil {
    public static void visitPartiallySchema(GraphQLSchema partiallyBuiltSchema, GraphQLTypeVisitor ... visitors) {
        ArrayList<GraphQLSchemaElement> roots = new ArrayList<GraphQLSchemaElement>();
        roots.add(partiallyBuiltSchema.getQueryType());
        if (partiallyBuiltSchema.isSupportingMutations()) {
            roots.add(partiallyBuiltSchema.getMutationType());
        }
        if (partiallyBuiltSchema.isSupportingSubscriptions()) {
            roots.add(partiallyBuiltSchema.getSubscriptionType());
        }
        if (partiallyBuiltSchema.getAdditionalTypes() != null) {
            roots.addAll(partiallyBuiltSchema.getAdditionalTypes());
        }
        if (partiallyBuiltSchema.getDirectives() != null) {
            roots.addAll(partiallyBuiltSchema.getDirectives());
        }
        roots.add(partiallyBuiltSchema.getIntrospectionSchemaType());
        MultiReadOnlyGraphQLTypeVisitor visitor = new MultiReadOnlyGraphQLTypeVisitor(Arrays.asList(visitors));
        SchemaTraverser traverser = new SchemaTraverser(schemaElement -> schemaElement.getChildrenWithTypeReferences().getChildrenAsList());
        traverser.depthFirst((GraphQLTypeVisitor)visitor, roots);
    }

    public static ImmutableMap<String, List<GraphQLObjectType>> groupInterfaceImplementationsByName(List<GraphQLNamedType> allTypesAsList) {
        LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
        for (GraphQLType graphQLType : allTypesAsList) {
            if (!(graphQLType instanceof GraphQLObjectType)) continue;
            List<GraphQLNamedOutputType> interfaces = ((GraphQLObjectType)graphQLType).getInterfaces();
            for (GraphQLNamedOutputType interfaceType : interfaces) {
                List myGroup = result.computeIfAbsent(interfaceType.getName(), k -> new ArrayList());
                myGroup.add((GraphQLObjectType)graphQLType);
            }
        }
        return ImmutableMap.copyOf(new TreeMap(result));
    }

    public Map<String, List<GraphQLImplementingType>> groupImplementationsForInterfacesAndObjects(GraphQLSchema schema) {
        LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
        for (GraphQLType graphQLType : schema.getAllTypesAsList()) {
            if (!(graphQLType instanceof GraphQLImplementingType)) continue;
            List<GraphQLNamedOutputType> interfaces = ((GraphQLImplementingType)graphQLType).getInterfaces();
            for (GraphQLNamedOutputType interfaceType : interfaces) {
                List myGroup = result.computeIfAbsent(interfaceType.getName(), k -> new ArrayList());
                myGroup.add((GraphQLImplementingType)graphQLType);
            }
        }
        return ImmutableMap.copyOf(new TreeMap(result));
    }

    public static void replaceTypeReferences(GraphQLSchema schema) {
        Map<String, GraphQLNamedType> typeMap = schema.getTypeMap();
        ArrayList<GraphQLNamedType> roots = new ArrayList<GraphQLNamedType>(typeMap.values());
        roots.addAll(schema.getDirectives());
        SchemaTraverser schemaTraverser = new SchemaTraverser(schemaElement -> schemaElement.getChildrenWithTypeReferences().getChildrenAsList());
        schemaTraverser.depthFirst((GraphQLTypeVisitor)new GraphQLTypeResolvingVisitor(typeMap), roots);
    }
}

