/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Directives;
import graphql.PublicApi;
import graphql.schema.GraphQLDirective;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@PublicApi
public class DirectiveInfo {
    public static final Set<GraphQLDirective> GRAPHQL_SPECIFICATION_DIRECTIVES = new LinkedHashSet<GraphQLDirective>();
    public static final Map<String, GraphQLDirective> GRAPHQL_SPECIFICATION_DIRECTIVE_MAP = new LinkedHashMap<String, GraphQLDirective>();

    public static boolean isGraphqlSpecifiedDirective(String directiveName) {
        return GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.containsKey(directiveName);
    }

    public static boolean isGraphqlSpecifiedDirective(GraphQLDirective graphQLDirective) {
        return DirectiveInfo.isGraphqlSpecifiedDirective(graphQLDirective.getName());
    }

    static {
        GRAPHQL_SPECIFICATION_DIRECTIVES.add(Directives.IncludeDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVES.add(Directives.SkipDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVES.add(Directives.DeprecatedDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVES.add(Directives.SpecifiedByDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.put(Directives.IncludeDirective.getName(), Directives.IncludeDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.put(Directives.SkipDirective.getName(), Directives.SkipDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.put(Directives.DeprecatedDirective.getName(), Directives.DeprecatedDirective);
        GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.put(Directives.SpecifiedByDirective.getName(), Directives.SpecifiedByDirective);
    }
}

