/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.com.google.common.collect.Sets;
import graphql.execution.ConditionalNodes;
import graphql.execution.MergedField;
import graphql.execution.ValuesResolver;
import graphql.execution.nextgen.Common;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;
import graphql.normalized.ENFMerger;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.normalized.FieldCollectorNormalizedQueryParams;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@Internal
public class ExecutableNormalizedOperationFactory {
    private final ValuesResolver valuesResolver = new ValuesResolver();
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, Document document, String operationName, Map<String, Object> coercedVariableValues) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        return new ExecutableNormalizedOperationFactory().createNormalizedQueryImpl(graphQLSchema, getOperationResult.operationDefinition, getOperationResult.fragmentsByName, coercedVariableValues, null);
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperation(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, Map<String, Object> coercedVariableValues) {
        return new ExecutableNormalizedOperationFactory().createNormalizedQueryImpl(graphQLSchema, operationDefinition, fragments, coercedVariableValues, null);
    }

    public static ExecutableNormalizedOperation createExecutableNormalizedOperationWithRawVariables(GraphQLSchema graphQLSchema, Document document, String operationName, Map<String, Object> rawVariables) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operationName);
        return new ExecutableNormalizedOperationFactory().createExecutableNormalizedOperationImplWithRawVariables(graphQLSchema, getOperationResult.operationDefinition, getOperationResult.fragmentsByName, rawVariables);
    }

    private ExecutableNormalizedOperation createExecutableNormalizedOperationImplWithRawVariables(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, Map<String, Object> rawVariables) {
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        Map<String, Object> coerceVariableValues = this.valuesResolver.coerceVariableValues(graphQLSchema, variableDefinitions, rawVariables);
        Map<String, NormalizedInputValue> normalizedVariableValues = this.valuesResolver.getNormalizedVariableValues(graphQLSchema, variableDefinitions, rawVariables);
        return this.createNormalizedQueryImpl(graphQLSchema, operationDefinition, fragments, coerceVariableValues, normalizedVariableValues);
    }

    private ExecutableNormalizedOperation createNormalizedQueryImpl(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition, Map<String, FragmentDefinition> fragments, Map<String, Object> coercedVariableValues, @Nullable Map<String, NormalizedInputValue> normalizedVariableValues) {
        FieldCollectorNormalizedQueryParams parameters = FieldCollectorNormalizedQueryParams.newParameters().fragments(fragments).schema(graphQLSchema).coercedVariables(coercedVariableValues).normalizedVariables(normalizedVariableValues).build();
        GraphQLObjectType rootType = Common.getOperationRootType(graphQLSchema, operationDefinition);
        CollectNFResult collectFromOperationResult = this.collectFromOperation(parameters, operationDefinition, rootType);
        ImmutableListMultimap.Builder<Field, ExecutableNormalizedField> fieldToNormalizedField = ImmutableListMultimap.builder();
        ImmutableMap.Builder<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField = ImmutableMap.builder();
        ImmutableListMultimap.Builder<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields = ImmutableListMultimap.builder();
        for (ExecutableNormalizedField topLevel : collectFromOperationResult.children) {
            ImmutableCollection mergedField = collectFromOperationResult.normalizedFieldToAstFields.get(topLevel);
            normalizedFieldToMergedField.put(topLevel, MergedField.newMergedField(ImmutableKit.map(mergedField, fieldAndAstParent -> fieldAndAstParent.field)).build());
            this.updateFieldToNFMap(topLevel, (ImmutableList<FieldAndAstParent>)mergedField, fieldToNormalizedField);
            this.updateCoordinatedToNFMap(coordinatesToNormalizedFields, topLevel);
            this.buildFieldWithChildren(topLevel, (ImmutableList<FieldAndAstParent>)mergedField, parameters, fieldToNormalizedField, normalizedFieldToMergedField, coordinatesToNormalizedFields, 1);
        }
        for (FieldCollectorNormalizedQueryParams.PossibleMerger possibleMerger : parameters.possibleMergerList) {
            List<ExecutableNormalizedField> childrenWithSameResultKey = possibleMerger.parent.getChildrenWithSameResultKey(possibleMerger.resultKey);
            ENFMerger.merge(possibleMerger.parent, childrenWithSameResultKey, graphQLSchema);
        }
        return new ExecutableNormalizedOperation(operationDefinition.getOperation(), operationDefinition.getName(), new ArrayList<ExecutableNormalizedField>(collectFromOperationResult.children), (ImmutableListMultimap<Field, ExecutableNormalizedField>)fieldToNormalizedField.build(), normalizedFieldToMergedField.build(), (ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField>)coordinatesToNormalizedFields.build());
    }

    private void buildFieldWithChildren(ExecutableNormalizedField field, ImmutableList<FieldAndAstParent> mergedField, FieldCollectorNormalizedQueryParams fieldCollectorNormalizedQueryParams, ImmutableListMultimap.Builder<Field, ExecutableNormalizedField> fieldNormalizedField, ImmutableMap.Builder<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField, ImmutableListMultimap.Builder<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields, int curLevel) {
        CollectNFResult nextLevel = this.collectFromMergedField(fieldCollectorNormalizedQueryParams, field, mergedField, curLevel + 1);
        for (ExecutableNormalizedField child : nextLevel.children) {
            field.addChild(child);
            ImmutableCollection mergedFieldForChild = nextLevel.normalizedFieldToAstFields.get(child);
            normalizedFieldToMergedField.put(child, MergedField.newMergedField(ImmutableKit.map(mergedFieldForChild, fieldAndAstParent -> fieldAndAstParent.field)).build());
            this.updateFieldToNFMap(child, (ImmutableList<FieldAndAstParent>)mergedFieldForChild, fieldNormalizedField);
            this.updateCoordinatedToNFMap(coordinatesToNormalizedFields, child);
            this.buildFieldWithChildren(child, (ImmutableList<FieldAndAstParent>)mergedFieldForChild, fieldCollectorNormalizedQueryParams, fieldNormalizedField, normalizedFieldToMergedField, coordinatesToNormalizedFields, curLevel + 1);
        }
    }

    private void updateFieldToNFMap(ExecutableNormalizedField executableNormalizedField, ImmutableList<FieldAndAstParent> mergedField, ImmutableListMultimap.Builder<Field, ExecutableNormalizedField> fieldToNormalizedField) {
        for (FieldAndAstParent astField : mergedField) {
            fieldToNormalizedField.put((Object)astField.field, (Object)executableNormalizedField);
        }
    }

    private void updateCoordinatedToNFMap(ImmutableListMultimap.Builder<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields, ExecutableNormalizedField topLevel) {
        for (String objectType : topLevel.getObjectTypeNames()) {
            FieldCoordinates coordinates = FieldCoordinates.coordinates(objectType, topLevel.getFieldName());
            coordinatesToNormalizedFields.put((Object)coordinates, (Object)topLevel);
        }
    }

    public CollectNFResult collectFromMergedField(FieldCollectorNormalizedQueryParams parameters, ExecutableNormalizedField executableNormalizedField, ImmutableList<FieldAndAstParent> mergedField, int level) {
        GraphQLUnmodifiedType fieldType = GraphQLTypeUtil.unwrapAll(executableNormalizedField.getType(parameters.getGraphQLSchema()));
        if (!(fieldType instanceof GraphQLCompositeType)) {
            return new CollectNFResult(Collections.emptyList(), ImmutableListMultimap.of());
        }
        ImmutableSet<GraphQLObjectType> possibleObjects = this.resolvePossibleObjects((GraphQLCompositeType)((Object)fieldType), parameters.getGraphQLSchema());
        ArrayList<CollectedField> collectedFields = new ArrayList<CollectedField>();
        for (FieldAndAstParent fieldAndAstParent : mergedField) {
            if (fieldAndAstParent.field.getSelectionSet() == null) continue;
            GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(parameters.getGraphQLSchema(), fieldAndAstParent.astParentType, fieldAndAstParent.field.getName());
            GraphQLUnmodifiedType astParentType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
            this.collectFromSelectionSet(parameters, fieldAndAstParent.field.getSelectionSet(), collectedFields, (GraphQLCompositeType)((Object)astParentType), possibleObjects);
        }
        LinkedHashMap<String, List<CollectedField>> fieldsByName = new LinkedHashMap<String, List<CollectedField>>();
        for (CollectedField collectedField : collectedFields) {
            fieldsByName.computeIfAbsent(collectedField.field.getResultKey(), ignored -> new ArrayList()).add(collectedField);
        }
        ArrayList<ExecutableNormalizedField> arrayList = new ArrayList<ExecutableNormalizedField>();
        ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields = ImmutableListMultimap.builder();
        this.createNFs(parameters, fieldsByName, arrayList, normalizedFieldToAstFields, level, executableNormalizedField);
        return new CollectNFResult(arrayList, (ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent>)normalizedFieldToAstFields.build());
    }

    public CollectNFResult collectFromOperation(FieldCollectorNormalizedQueryParams parameters, OperationDefinition operationDefinition, GraphQLObjectType rootType) {
        LinkedHashSet<GraphQLObjectType> possibleObjects = new LinkedHashSet<GraphQLObjectType>();
        possibleObjects.add(rootType);
        ArrayList<CollectedField> collectedFields = new ArrayList<CollectedField>();
        this.collectFromSelectionSet(parameters, operationDefinition.getSelectionSet(), collectedFields, rootType, possibleObjects);
        LinkedHashMap<String, List<CollectedField>> fieldsByName = new LinkedHashMap<String, List<CollectedField>>();
        for (CollectedField collectedField : collectedFields) {
            fieldsByName.computeIfAbsent(collectedField.field.getResultKey(), ignored -> new ArrayList()).add(collectedField);
        }
        ArrayList<ExecutableNormalizedField> resultNFs = new ArrayList<ExecutableNormalizedField>();
        ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields = ImmutableListMultimap.builder();
        this.createNFs(parameters, fieldsByName, resultNFs, normalizedFieldToAstFields, 1, null);
        return new CollectNFResult(resultNFs, (ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent>)normalizedFieldToAstFields.build());
    }

    private void createNFs(FieldCollectorNormalizedQueryParams parameters, Map<String, List<CollectedField>> fieldsByName, List<ExecutableNormalizedField> resultNFs, ImmutableListMultimap.Builder<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields, int level, ExecutableNormalizedField parent) {
        for (String resultKey : fieldsByName.keySet()) {
            List<CollectedField> fieldsWithSameResultKey = fieldsByName.get(resultKey);
            List<CollectedFieldGroup> commonParentsGroups = this.groupByCommonParents(fieldsWithSameResultKey);
            for (CollectedFieldGroup fieldGroup : commonParentsGroups) {
                ExecutableNormalizedField nf = this.createNF(parameters, fieldGroup, level, parent);
                if (nf == null) continue;
                for (CollectedField collectedField : fieldGroup.fields) {
                    normalizedFieldToAstFields.put((Object)nf, (Object)new FieldAndAstParent(collectedField.field, collectedField.astTypeCondition));
                }
                resultNFs.add(nf);
            }
            if (commonParentsGroups.size() <= 1) continue;
            parameters.addPossibleMergers(parent, resultKey);
        }
    }

    private ExecutableNormalizedField createNF(FieldCollectorNormalizedQueryParams parameters, CollectedFieldGroup collectedFieldGroup, int level, ExecutableNormalizedField parent) {
        Set<GraphQLObjectType> objectTypes = collectedFieldGroup.objectTypes;
        Field field = collectedFieldGroup.fields.iterator().next().field;
        String fieldName = field.getName();
        GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(parameters.getGraphQLSchema(), objectTypes.iterator().next(), fieldName);
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), parameters.getCoercedVariableValues());
        Map<String, NormalizedInputValue> normalizedArgumentValues = null;
        if (parameters.getNormalizedVariableValues() != null) {
            normalizedArgumentValues = this.valuesResolver.getNormalizedArgumentValues(fieldDefinition.getArguments(), field.getArguments(), parameters.getNormalizedVariableValues());
        }
        ImmutableList<String> objectTypeNames = ImmutableKit.map(objectTypes, GraphQLObjectType::getName);
        ExecutableNormalizedField executableNormalizedField = ExecutableNormalizedField.newNormalizedField().alias(field.getAlias()).resolvedArguments(argumentValues).normalizedArguments(normalizedArgumentValues).astArguments(field.getArguments()).objectTypeNames(objectTypeNames).fieldName(fieldName).level(level).parent(parent).build();
        return executableNormalizedField;
    }

    private List<CollectedFieldGroup> groupByCommonParents(Collection<CollectedField> fields) {
        LinkedHashSet<GraphQLObjectType> allRelevantObjects = new LinkedHashSet<GraphQLObjectType>();
        for (CollectedField collectedField : fields) {
            allRelevantObjects.addAll(collectedField.objectTypes);
        }
        Map<GraphQLType, ImmutableList<CollectedField>> groupByAstParent = FpKit.groupingBy(fields, fieldAndType -> fieldAndType.astTypeCondition);
        if (groupByAstParent.size() == 1) {
            return Collections.singletonList(new CollectedFieldGroup(new LinkedHashSet<CollectedField>(fields), allRelevantObjects));
        }
        ArrayList<CollectedFieldGroup> result = new ArrayList<CollectedFieldGroup>();
        for (GraphQLObjectType objectType : allRelevantObjects) {
            Set<CollectedField> relevantFields = FpKit.filterSet(fields, field -> field.objectTypes.contains(objectType));
            result.add(new CollectedFieldGroup(relevantFields, Collections.singleton(objectType)));
        }
        return result;
    }

    private void collectFromSelectionSet(FieldCollectorNormalizedQueryParams parameters, SelectionSet selectionSet, List<CollectedField> result, GraphQLCompositeType astTypeCondition, Set<GraphQLObjectType> possibleObjects) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectField(parameters, result, (Field)selection, possibleObjects, astTypeCondition);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(parameters, result, (InlineFragment)selection, possibleObjects, astTypeCondition);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(parameters, result, (FragmentSpread)selection, possibleObjects, astTypeCondition);
        }
    }

    private void collectFragmentSpread(FieldCollectorNormalizedQueryParams parameters, List<CollectedField> result, FragmentSpread fragmentSpread, Set<GraphQLObjectType> possibleObjects, GraphQLCompositeType astTypeCondition) {
        if (!this.conditionalNodes.shouldInclude(parameters.getCoercedVariableValues(), fragmentSpread.getDirectives())) {
            return;
        }
        FragmentDefinition fragmentDefinition = Assert.assertNotNull(parameters.getFragmentsByName().get(fragmentSpread.getName()));
        if (!this.conditionalNodes.shouldInclude(parameters.getCoercedVariableValues(), fragmentDefinition.getDirectives())) {
            return;
        }
        GraphQLCompositeType newAstTypeCondition = (GraphQLCompositeType)Assert.assertNotNull(parameters.getGraphQLSchema().getType(fragmentDefinition.getTypeCondition().getName()));
        Set<GraphQLObjectType> newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition, parameters.getGraphQLSchema());
        this.collectFromSelectionSet(parameters, fragmentDefinition.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
    }

    private void collectInlineFragment(FieldCollectorNormalizedQueryParams parameters, List<CollectedField> result, InlineFragment inlineFragment, Set<GraphQLObjectType> possibleObjects, GraphQLCompositeType astTypeCondition) {
        if (!this.conditionalNodes.shouldInclude(parameters.getCoercedVariableValues(), inlineFragment.getDirectives())) {
            return;
        }
        Set<GraphQLObjectType> newPossibleObjects = possibleObjects;
        GraphQLCompositeType newAstTypeCondition = astTypeCondition;
        if (inlineFragment.getTypeCondition() != null) {
            newAstTypeCondition = (GraphQLCompositeType)parameters.getGraphQLSchema().getType(inlineFragment.getTypeCondition().getName());
            newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition, parameters.getGraphQLSchema());
        }
        this.collectFromSelectionSet(parameters, inlineFragment.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
    }

    private void collectField(FieldCollectorNormalizedQueryParams parameters, List<CollectedField> result, Field field, Set<GraphQLObjectType> possibleObjectTypes, GraphQLCompositeType astTypeCondition) {
        if (!this.conditionalNodes.shouldInclude(parameters.getCoercedVariableValues(), field.getDirectives())) {
            return;
        }
        if (possibleObjectTypes.size() == 0) {
            return;
        }
        result.add(new CollectedField(field, possibleObjectTypes, astTypeCondition));
    }

    private Set<GraphQLObjectType> narrowDownPossibleObjects(Set<GraphQLObjectType> currentOnes, GraphQLCompositeType typeCondition, GraphQLSchema graphQLSchema) {
        ImmutableSet<GraphQLObjectType> resolvedTypeCondition = this.resolvePossibleObjects(typeCondition, graphQLSchema);
        if (currentOnes.size() == 0) {
            return resolvedTypeCondition;
        }
        return Sets.intersection(currentOnes, resolvedTypeCondition);
    }

    private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(GraphQLCompositeType type, GraphQLSchema graphQLSchema) {
        if (type instanceof GraphQLObjectType) {
            return ImmutableSet.of((GraphQLObjectType)type);
        }
        if (type instanceof GraphQLInterfaceType) {
            return ImmutableSet.copyOf(graphQLSchema.getImplementations((GraphQLInterfaceType)type));
        }
        if (type instanceof GraphQLUnionType) {
            List<GraphQLNamedOutputType> types = ((GraphQLUnionType)type).getTypes();
            return ImmutableSet.copyOf(types);
        }
        return (ImmutableSet)Assert.assertShouldNeverHappen();
    }

    private static class CollectedField {
        Field field;
        Set<GraphQLObjectType> objectTypes;
        GraphQLCompositeType astTypeCondition;

        public CollectedField(Field field, Set<GraphQLObjectType> objectTypes, GraphQLCompositeType astTypeCondition) {
            this.field = field;
            this.objectTypes = objectTypes;
            this.astTypeCondition = astTypeCondition;
        }

        public boolean isAbstract() {
            return GraphQLTypeUtil.isInterfaceOrUnion(this.astTypeCondition);
        }

        public boolean isConcrete() {
            return GraphQLTypeUtil.isObjectType(this.astTypeCondition);
        }
    }

    private static class CollectedFieldGroup {
        Set<GraphQLObjectType> objectTypes;
        Set<CollectedField> fields;

        public CollectedFieldGroup(Set<CollectedField> fields, Set<GraphQLObjectType> objectTypes) {
            this.fields = fields;
            this.objectTypes = objectTypes;
        }
    }

    public static class CollectNFResult {
        private final Collection<ExecutableNormalizedField> children;
        private final ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields;

        public CollectNFResult(Collection<ExecutableNormalizedField> children, ImmutableListMultimap<ExecutableNormalizedField, FieldAndAstParent> normalizedFieldToAstFields) {
            this.children = children;
            this.normalizedFieldToAstFields = normalizedFieldToAstFields;
        }
    }

    private static class FieldAndAstParent {
        final Field field;
        final GraphQLCompositeType astParentType;

        private FieldAndAstParent(Field field, GraphQLCompositeType astParentType) {
            this.field = field;
            this.astParentType = astParentType;
        }
    }
}

