/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.PublicApi;
import graphql.language.AstNodeAdapter;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import graphql.util.TreeParallelTransformer;
import graphql.util.TreeTransformer;
import java.util.concurrent.ForkJoinPool;

@PublicApi
public class AstTransformer {
    public Node transform(Node root, final NodeVisitor nodeVisitor) {
        Assert.assertNotNull(root);
        Assert.assertNotNull(nodeVisitor);
        TraverserVisitor<Node> traverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                return TraversalControl.CONTINUE;
            }
        };
        TreeTransformer<Node> treeTransformer = new TreeTransformer<Node>(AstNodeAdapter.AST_NODE_ADAPTER);
        return treeTransformer.transform(root, traverserVisitor);
    }

    public Node transformParallel(Node root, NodeVisitor nodeVisitor) {
        return this.transformParallel(root, nodeVisitor, ForkJoinPool.commonPool());
    }

    public Node transformParallel(Node root, final NodeVisitor nodeVisitor, ForkJoinPool forkJoinPool) {
        Assert.assertNotNull(root);
        Assert.assertNotNull(nodeVisitor);
        TraverserVisitorStub<Node> traverserVisitor = new TraverserVisitorStub<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }
        };
        TreeParallelTransformer<Node> treeParallelTransformer = TreeParallelTransformer.parallelTransformer(AstNodeAdapter.AST_NODE_ADAPTER, forkJoinPool);
        return treeParallelTransformer.transform(root, (TraverserVisitor<Node>)traverserVisitor);
    }
}

