/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.remote.http.HttpRequest;

public class FormEncodedData {
    public static Optional<Map<String, List<String>>> getData(HttpRequest request) {
        try {
            String contentType = request.getHeader("Content-Type");
            MediaType type = MediaType.parse(contentType);
            if (!type.is(MediaType.FORM_DATA)) {
                return Optional.empty();
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
        LinkedListMultimap<String, String> data = LinkedListMultimap.create();
        AtomicBoolean eof = new AtomicBoolean(false);
        Charset encoding = request.getContentEncoding();
        try (InputStream is = (InputStream)request.getContent().get();
             InputStreamReader reader = new InputStreamReader(is, request.getContentEncoding());){
            while (!eof.get()) {
                String key = FormEncodedData.read(reader, encoding, '=', eof);
                String value = FormEncodedData.read(reader, encoding, '&', eof);
                data.put(key, value == null ? "" : value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ImmutableMap.Builder toReturn = ImmutableMap.builder();
        for (Map.Entry entry : data.asMap().entrySet()) {
            toReturn.put((String)entry.getKey(), ImmutableList.copyOf(entry.getValue()));
        }
        return Optional.of(toReturn.build());
    }

    private static String read(Reader reader, Charset charSet, char delimiter, AtomicBoolean eof) throws IOException {
        if (eof.get()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (true) {
            int i;
            if ((i = reader.read()) == -1) {
                eof.set(true);
                break;
            }
            char c = (char)i;
            if (c == delimiter) break;
            builder.append(c);
        }
        return URLDecoder.decode(builder.toString(), charSet.toString());
    }
}

