/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.TextMessage;

class MessageInboundConverter
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger LOG = Logger.getLogger(MessageInboundConverter.class.getName());

    MessageInboundConverter() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        void var3_9;
        if (!frame.isFinalFragment()) {
            LOG.warning("Frame is not final. Chaos may ensue");
        }
        Object var3_3 = null;
        if (frame instanceof TextWebSocketFrame) {
            TextMessage textMessage = new TextMessage(((TextWebSocketFrame)frame).text());
        } else if (frame instanceof BinaryWebSocketFrame) {
            ByteBuf buf = frame.content();
            if (buf.nioBufferCount() != -1) {
                BinaryMessage binaryMessage = new BinaryMessage(buf.nioBuffer());
            } else {
                if (!buf.hasArray()) throw new IllegalStateException("Unable to handle bytebuf: " + buf);
                BinaryMessage binaryMessage = new BinaryMessage(ByteBuffer.wrap(buf.array()));
            }
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            CloseMessage closeMessage = new CloseMessage(closeFrame.statusCode(), closeFrame.reasonText());
        }
        if (var3_9 != null) {
            ctx.fireChannelRead(var3_9);
            return;
        } else {
            ctx.write(frame);
        }
    }
}

