/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;

class ServletResponseWrappingHttpResponse
extends HttpResponse {
    private final HttpServletResponse resp;

    ServletResponseWrappingHttpResponse(HttpServletResponse resp) {
        this.resp = Require.nonNull("Response to wrap", resp);
    }

    @Override
    public int getStatus() {
        return this.resp.getStatus();
    }

    @Override
    public ServletResponseWrappingHttpResponse setStatus(int status) {
        this.resp.setStatus(status);
        return this;
    }

    @Override
    public Iterable<String> getHeaderNames() {
        return this.resp.getHeaderNames();
    }

    @Override
    public Iterable<String> getHeaders(String name) {
        return this.resp.getHeaders(name);
    }

    @Override
    public String getHeader(String name) {
        return this.resp.getHeader(name);
    }

    @Override
    public ServletResponseWrappingHttpResponse setHeader(String name, String value) {
        this.resp.setHeader(name, value);
        return this;
    }

    @Override
    public ServletResponseWrappingHttpResponse addHeader(String name, String value) {
        this.resp.addHeader(name, value);
        return this;
    }

    @Override
    public ServletResponseWrappingHttpResponse removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    @Override
    public ServletResponseWrappingHttpResponse setContent(Supplier<InputStream> supplier) {
        byte[] bytes = Contents.bytes(supplier);
        this.resp.setContentLength(bytes.length);
        try (InputStream is = supplier.get();
             ServletOutputStream os = this.resp.getOutputStream();){
            ByteStreams.copy(is, os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public Supplier<InputStream> getContent() {
        throw new UnsupportedOperationException("getContent");
    }
}

