/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Message;

public abstract class TemplateGridServerCommand
extends TemplateGridCommand {
    public Server<?> asServer(Config initialConfig) {
        Require.nonNull("Config", initialConfig);
        MemoizedConfig config = new MemoizedConfig(new CompoundConfig(initialConfig, this.getDefaultConfig()));
        Handlers handler = this.createHandlers(config);
        return new NettyServer(new BaseServerOptions(config), handler.httpHandler, handler.websocketHandler);
    }

    protected abstract Handlers createHandlers(Config var1);

    public static class Handlers {
        public final HttpHandler httpHandler;
        public final BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler;

        public Handlers(HttpHandler http, BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler) {
            this.httpHandler = Require.nonNull("HTTP handler", http);
            this.websocketHandler = websocketHandler == null ? (str, sink) -> Optional.empty() : websocketHandler;
        }
    }
}

