/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.network.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v96.network.model.BlockedCookieWithReason;
import org.openqa.selenium.devtools.v96.network.model.ClientSecurityState;
import org.openqa.selenium.devtools.v96.network.model.ConnectTiming;
import org.openqa.selenium.devtools.v96.network.model.Headers;
import org.openqa.selenium.devtools.v96.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestWillBeSentExtraInfo {
    private final RequestId requestId;
    private final List<BlockedCookieWithReason> associatedCookies;
    private final Headers headers;
    private final ConnectTiming connectTiming;
    private final Optional<ClientSecurityState> clientSecurityState;

    public RequestWillBeSentExtraInfo(RequestId requestId, List<BlockedCookieWithReason> associatedCookies, Headers headers, ConnectTiming connectTiming, Optional<ClientSecurityState> clientSecurityState) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.connectTiming = Objects.requireNonNull(connectTiming, "connectTiming is required");
        this.clientSecurityState = clientSecurityState;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedCookieWithReason> getAssociatedCookies() {
        return this.associatedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    @Beta
    public ConnectTiming getConnectTiming() {
        return this.connectTiming;
    }

    public Optional<ClientSecurityState> getClientSecurityState() {
        return this.clientSecurityState;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List associatedCookies = null;
        Headers headers = null;
        ConnectTiming connectTiming = null;
        Optional<ClientSecurityState> clientSecurityState = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block14;
                }
                case "associatedCookies": {
                    associatedCookies = (List)input.read(new TypeToken<List<BlockedCookieWithReason>>(){}.getType());
                    continue block14;
                }
                case "headers": {
                    headers = (Headers)input.read((Type)((Object)Headers.class));
                    continue block14;
                }
                case "connectTiming": {
                    connectTiming = (ConnectTiming)input.read((Type)((Object)ConnectTiming.class));
                    continue block14;
                }
                case "clientSecurityState": {
                    clientSecurityState = Optional.ofNullable((ClientSecurityState)input.read((Type)((Object)ClientSecurityState.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers, connectTiming, clientSecurityState);
    }
}

