/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class SlotId
implements Serializable {
    private final NodeId nodeId;
    private final UUID uuid;

    public SlotId(NodeId host, UUID uuid) {
        this.nodeId = Require.nonNull("Host id", host);
        this.uuid = Require.nonNull("Actual id", uuid);
    }

    public NodeId getOwningNodeId() {
        return this.nodeId;
    }

    public UUID getSlotId() {
        return this.uuid;
    }

    public String toString() {
        return "SlotId{nodeId=" + this.nodeId + ", id=" + this.uuid + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlotId)) {
            return false;
        }
        SlotId that = (SlotId)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.uuid);
    }

    private Object toJson() {
        TreeMap<String, Comparable<NodeId>> toReturn = new TreeMap<String, Comparable<NodeId>>();
        toReturn.put("hostId", this.nodeId);
        toReturn.put("id", this.uuid);
        return Collections.unmodifiableMap(toReturn);
    }

    private static SlotId fromJson(JsonInput input) {
        NodeId nodeId = null;
        UUID id = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "hostId": {
                    nodeId = (NodeId)input.read((Type)((Object)NodeId.class));
                    continue block8;
                }
                case "id": {
                    id = (UUID)input.read((Type)((Object)UUID.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SlotId(nodeId, id);
    }
}

