/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.fetch;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v85.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v85.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v85.fetch.model.RequestId;
import org.openqa.selenium.devtools.v85.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v85.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v85.io.model.StreamHandle;
import org.openqa.selenium.devtools.v85.network.model.ErrorReason;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Fetch {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Fetch.disable", params.build());
    }

    public static Command<Void> enable(Optional<List<RequestPattern>> patterns, Optional<Boolean> handleAuthRequests) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        patterns.ifPresent(p -> params.put("patterns", p));
        handleAuthRequests.ifPresent(p -> params.put("handleAuthRequests", p));
        return new Command<Void>("Fetch.enable", params.build());
    }

    public static Command<Void> failRequest(RequestId requestId, ErrorReason errorReason) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(errorReason, "errorReason is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        params.put("errorReason", (Object)errorReason);
        return new Command<Void>("Fetch.failRequest", params.build());
    }

    public static Command<Void> fulfillRequest(RequestId requestId, Integer responseCode, Optional<List<HeaderEntry>> responseHeaders, Optional<String> binaryResponseHeaders, Optional<String> body, Optional<String> responsePhrase) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(responseCode, "responseCode is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        params.put("responseCode", responseCode);
        responseHeaders.ifPresent(p -> params.put("responseHeaders", p));
        binaryResponseHeaders.ifPresent(p -> params.put("binaryResponseHeaders", p));
        body.ifPresent(p -> params.put("body", p));
        responsePhrase.ifPresent(p -> params.put("responsePhrase", p));
        return new Command<Void>("Fetch.fulfillRequest", params.build());
    }

    public static Command<Void> continueRequest(RequestId requestId, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<List<HeaderEntry>> headers) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        url.ifPresent(p -> params.put("url", (RequestId)p));
        method.ifPresent(p -> params.put("method", (RequestId)p));
        postData.ifPresent(p -> params.put("postData", (RequestId)p));
        headers.ifPresent(p -> params.put("headers", (RequestId)p));
        return new Command<Void>("Fetch.continueRequest", params.build());
    }

    public static Command<Void> continueWithAuth(RequestId requestId, AuthChallengeResponse authChallengeResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(authChallengeResponse, "authChallengeResponse is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        params.put("authChallengeResponse", authChallengeResponse);
        return new Command<Void>("Fetch.continueWithAuth", params.build());
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        return new Command<GetResponseBodyResponse>("Fetch.getResponseBody", params.build(), input -> (GetResponseBodyResponse)input.read((Type)((Object)GetResponseBodyResponse.class)));
    }

    public static Command<StreamHandle> takeResponseBodyAsStream(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        return new Command<StreamHandle>("Fetch.takeResponseBodyAsStream", params.build(), ConverterFunctions.map("stream", StreamHandle.class));
    }

    public static Event<RequestPaused> requestPaused() {
        return new Event<RequestPaused>("Fetch.requestPaused", input -> (RequestPaused)input.read((Type)((Object)RequestPaused.class)));
    }

    public static Event<AuthRequired> authRequired() {
        return new Event<AuthRequired>("Fetch.authRequired", input -> (AuthRequired)input.read((Type)((Object)AuthRequired.class)));
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

