/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.AddHasCasting;
import org.openqa.selenium.chrome.AddHasCdp;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriver
extends ChromiumDriver {
    public ChromeDriver() {
        this(ChromeDriverService.createDefaultService(), new ChromeOptions());
    }

    public ChromeDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    @Deprecated
    public ChromeDriver(Capabilities capabilities) {
        this(ChromeDriverService.createDefaultService(), capabilities);
    }

    public ChromeDriver(ChromeOptions options) {
        this(ChromeDriverService.createServiceWithConfig(options), options);
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options) {
        this(service, (Capabilities)options);
    }

    @Deprecated
    public ChromeDriver(ChromeDriverService service, Capabilities capabilities) {
        super(new ChromeDriverCommandExecutor(service), capabilities, "goog:chromeOptions");
        this.casting = new AddHasCasting().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.cdp = new AddHasCdp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    }

    private static class ChromeDriverCommandExecutor
    extends ChromiumDriverCommandExecutor {
        public ChromeDriverCommandExecutor(DriverService service) {
            super(service, ChromeDriverCommandExecutor.getExtraCommands());
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasCasting().getAdditionalCommands()).putAll(new AddHasCdp().getAdditionalCommands()).build();
        }
    }
}

