/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class SdkMeterProviderBuilder {
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();
    private final List<MetricReaderFactory> metricReaders = new ArrayList<MetricReaderFactory>();
    private ExemplarFilter exemplarFilter = ExemplarFilter.sampleWithTraces();
    private long minimumCollectionIntervalNanos = TimeUnit.MILLISECONDS.toNanos(100L);

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.viewRegistryBuilder.addView(selector, view);
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMeterProvider.set(meterProvider);
        return meterProvider;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReaderFactory reader) {
        this.metricReaders.add(reader);
        return this;
    }

    public SdkMeterProviderBuilder setMinimumCollectionInterval(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        Utils.checkArgument(!duration.isNegative(), "duration must not be negative");
        this.minimumCollectionIntervalNanos = duration.toNanos();
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.metricReaders, this.clock, this.resource, this.viewRegistryBuilder.build(), this.exemplarFilter, this.minimumCollectionIntervalNanos);
    }
}

