/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Internal;
import graphql.SerializationError;
import graphql.TypeMismatchError;
import graphql.UnresolvedTypeError;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.FetchedValue;
import graphql.execution.MergedField;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResolveType;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.nextgen.FetchedValueAnalysis;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;

@Internal
public class FetchedValueAnalyzer {
    ExecutionStepInfoFactory executionInfoFactory = new ExecutionStepInfoFactory();
    ResolveType resolveType = new ResolveType();

    public FetchedValueAnalysis analyzeFetchedValue(ExecutionContext executionContext, FetchedValue fetchedValue, ExecutionStepInfo executionInfo) throws NonNullableFieldWasNullException {
        return this.analyzeFetchedValueImpl(executionContext, fetchedValue, fetchedValue.getFetchedValue(), executionInfo);
    }

    private FetchedValueAnalysis analyzeFetchedValueImpl(ExecutionContext executionContext, FetchedValue fetchedValue, Object toAnalyze, ExecutionStepInfo executionInfo) throws NonNullableFieldWasNullException {
        GraphQLOutputType fieldType = executionInfo.getUnwrappedNonNullType();
        MergedField field = executionInfo.getField();
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.analyzeList(executionContext, fetchedValue, toAnalyze, executionInfo);
        }
        if (fieldType instanceof GraphQLScalarType) {
            return this.analyzeScalarValue(fetchedValue, toAnalyze, (GraphQLScalarType)fieldType, executionInfo);
        }
        if (fieldType instanceof GraphQLEnumType) {
            return this.analyzeEnumValue(fetchedValue, toAnalyze, (GraphQLEnumType)fieldType, executionInfo);
        }
        if (toAnalyze == null) {
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.OBJECT).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().build();
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType.resolveType(executionContext, field, toAnalyze, executionInfo.getArguments(), fieldType);
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.OBJECT).fetchedValue(fetchedValue).executionStepInfo(executionInfo).completedValue(toAnalyze).resolvedType(resolvedObjectType).build();
        }
        catch (UnresolvedTypeException ex) {
            return this.handleUnresolvedTypeProblem(fetchedValue, executionInfo, ex);
        }
    }

    private FetchedValueAnalysis handleUnresolvedTypeProblem(FetchedValue fetchedValue, ExecutionStepInfo executionInfo, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(executionInfo.getPath(), executionInfo, e);
        return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.OBJECT).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().error(error).build();
    }

    private FetchedValueAnalysis analyzeList(ExecutionContext executionContext, FetchedValue fetchedValue, Object toAnalyze, ExecutionStepInfo executionInfo) {
        if (toAnalyze == null) {
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.LIST).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().build();
        }
        if (toAnalyze.getClass().isArray() || toAnalyze instanceof Iterable) {
            Collection<Object> collection = FpKit.toCollection(toAnalyze);
            return this.analyzeIterable(executionContext, fetchedValue, collection, executionInfo);
        }
        TypeMismatchError error = new TypeMismatchError(executionInfo.getPath(), executionInfo.getType());
        return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.LIST).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().error(error).build();
    }

    private FetchedValueAnalysis analyzeIterable(ExecutionContext executionContext, FetchedValue fetchedValue, Iterable<Object> iterableValues, ExecutionStepInfo executionInfo) {
        Collection values = FpKit.toCollection(iterableValues);
        ArrayList<FetchedValueAnalysis> children = new ArrayList<FetchedValueAnalysis>();
        int index = 0;
        for (Object item : values) {
            ExecutionStepInfo executionInfoForListElement = this.executionInfoFactory.newExecutionStepInfoForListElement(executionInfo, index);
            children.add(this.analyzeFetchedValueImpl(executionContext, fetchedValue, item, executionInfoForListElement));
            ++index;
        }
        return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.LIST).fetchedValue(fetchedValue).executionStepInfo(executionInfo).children(children).build();
    }

    private FetchedValueAnalysis analyzeScalarValue(FetchedValue fetchedValue, Object toAnalyze, GraphQLScalarType scalarType, ExecutionStepInfo executionInfo) {
        Object serialized;
        if (toAnalyze == null) {
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().build();
        }
        try {
            serialized = this.serializeScalarValue(toAnalyze, scalarType);
        }
        catch (CoercingSerializeException e) {
            SerializationError error = new SerializationError(executionInfo.getPath(), e);
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).error(error).nullValue().build();
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().build();
        }
        return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).completedValue(serialized).build();
    }

    protected Object serializeScalarValue(Object toAnalyze, GraphQLScalarType scalarType) throws CoercingSerializeException {
        return scalarType.getCoercing().serialize(toAnalyze);
    }

    private FetchedValueAnalysis analyzeEnumValue(FetchedValue fetchedValue, Object toAnalyze, GraphQLEnumType enumType, ExecutionStepInfo executionInfo) {
        Object serialized;
        if (toAnalyze == null) {
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().build();
        }
        try {
            serialized = enumType.serialize(toAnalyze);
        }
        catch (CoercingSerializeException e) {
            SerializationError error = new SerializationError(executionInfo.getPath(), e);
            return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.SCALAR).fetchedValue(fetchedValue).executionStepInfo(executionInfo).nullValue().error(error).build();
        }
        return FetchedValueAnalysis.newFetchedValueAnalysis(FetchedValueAnalysis.FetchedValueType.ENUM).fetchedValue(fetchedValue).executionStepInfo(executionInfo).completedValue(serialized).build();
    }
}

