﻿using System.Linq;
using Xunit;

namespace MastermindGame.Tests
{
    public class WriteTests
    {
        [Fact]
        public void ItCanBeWrittenTo()
        {
            var inout = new MockInputOutput();

            // Act
            inout.Write("Tekst");
        }

        [Fact]
        public void WrittenTextCanBeRetrieved()
        {
            // Arrange
            var inout = new MockInputOutput();
            inout.Write("Tekst");

            // Act    
            var writtenText = inout.OutFeed;

            // Assert
            Assert.Single(writtenText);
            Assert.Equal("Tekst", writtenText.First());
        }
    }
}