import { expect } from 'chai';
import * as actions from '../actions/speakerActions';
import * as types from './actionTypes';
import { speakersReducer, speakerReducer } from './speakerReducer';

describe('Reduktory dla prelegentów', () => {
  describe('Reduktor prelegentów', () => {
    it('istnieje', () => {
      expect(speakersReducer).to.exist;
    });

    it('Ładuje prelegentów', () => {
      // arrange
      const initialState = [];

      const speaker = {
        id: 'testowy-prelegent',
        firstName: 'Testowy',
        lastName: 'Prelegent'
      };
      const action = actions.getSpeakersSuccess([speaker]);

      // act
      const newState = speakersReducer(initialState, action);

      // assert
      expect(newState).to.have.lengthOf(1);
      expect(newState[0]).to.deep.equal(speaker);
    });
  });

  describe('Reduktor prelegenta', () => {
    it('istnieje', () => {
      expect(speakerReducer).to.exist;
    });

    it('otrzymuje prelegenta', () => {
      // arrange
      const initialState = { id: '', firstName: '', lastName: '' };
      const speaker = { id: 'testowy-prelegent', firstName: 'Testowy', lastName: 'Prelegent'};
      const action = actions.getSpeakerSuccess(speaker);
    
      // act
      const newState = speakerReducer(initialState, action);
    
      // assert
      expect(newState).to.deep.equal(speaker);
    });
  });
});
