"""
Ustawienia Django dla projektu superlists.

Więcej informacji dotyczących tego pliku znajdziesz na stronie
https://docs.djangoproject.com/en/1.7/topics/settings/

Pełną listę opcji oraz ich wartości znajdziesz na stronie
https://docs.djangoproject.com/en/1.7/ref/settings/
"""

# W projekcie ścieżki dostępu są tworzone następująco: os.path.join(BASE_DIR, ...).
import os
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Ustawienia programistyczne pozwalające na szybkie rozpoczęcie pracy,
# nieodpowiednie dla środowiska produkcyjnego.
# Patrz https://docs.djangoproject.com/en/1.7/howto/deployment/checklist/

# OSTRZEŻENIE BEZPIECZEŃSTWA: nie ujawniaj klucza używanego w środowisku produkcyjnym!
SECRET_KEY = '$xpu341d5va$lgq!#6d6@$y^plyga3a@0bgu9lme&@&*v8cd59'

# OSTRZEŻENIE BEZPIECZEŃSTWA: nie pozostawiaj włączonej opcji DEBUG w środowisku produkcyjnym!
DEBUG = True

TEMPLATE_DEBUG = True

# Poniższa opcja jest zmieniana przez skrypt wdrożęnia.
DOMAIN = "localhost"

ALLOWED_HOSTS = [DOMAIN]



# Definicja aplikacji.

INSTALLED_APPS = (
    #'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'lists',
    'accounts',
    'functional_tests',
)

AUTH_USER_MODEL = 'accounts.User'
AUTHENTICATION_BACKENDS = (
    'accounts.authentication.PersonaAuthenticationBackend',
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
)

ROOT_URLCONF = 'superlists.urls'

WSGI_APPLICATION = 'superlists.wsgi.application'


# Baza danych.
# https://docs.djangoproject.com/en/1.7/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, '../database/db.sqlite3'),
    }
}

# Ustawienia językowe.
# https://docs.djangoproject.com/en/1.7/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Pliki statyczne (CSS, JavaScript, obrazy).
# https://docs.djangoproject.com/en/1.7/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, '../static')

STATICFILES_DIRS = (
    os.path.join(BASE_DIR, 'superlists', 'static'),
)

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['console'],
        },
        'accounts': {
            'handlers': ['console'],
        },
        'lists': {
            'handlers': ['console'],
        },
    },
    'root': {'level': 'INFO'},
}

