package com.packtpublishing.tddjava.ch02friendships;

import com.packtpublishing.tddjava.ch02friendships.Friendships;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.util.Arrays;
import java.util.List;

public class FriendshipsTest {
    @Test(groups = { "base" })
    public void test1() {
        Friendships friendships = new Friendships();

        Assert.assertTrue(friendships.getFriendsList("Joe").isEmpty(), "Joe nie ma przyjaciół");
    }

    @Test(groups = { "base" })
    public void test2() {
        Friendships friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");

        Assert.assertTrue(friendships.areFriends("Joe", "Audrey"), "Joe i Audrey są przyjaciółmi");
        Assert.assertTrue(friendships.areFriends("Audrey", "Joe"), "Audrey i Joe są przyjaciółmi");

        Assert.assertTrue(friendships.getFriendsList("Joe").contains("Audrey"), "Audrey jest przyjacielem Joe");
        Assert.assertEquals(1, friendships.getFriendsList("Joe").size(), "Joe ma jednego przyjaciela");

        Assert.assertTrue(friendships.getFriendsList("Audrey").contains("Joe"), "Joe jest przyjacielem Audrey");
        Assert.assertEquals(1, friendships.getFriendsList("Audrey").size(), "Audrey ma jednego przyjaciela");
    }

    @Test(groups = { "complex" }, dependsOnGroups = { "base" }, timeOut = 10)
    public void test3() {
        Friendships friendships = new Friendships();
        friendships.makeFriends("Joe", "Audrey");
        friendships.makeFriends("Joe", "Peter");
        friendships.makeFriends("Joe", "Michael");
        friendships.makeFriends("Joe", "Britney");
        friendships.makeFriends("Joe", "Paul");

        Assert.assertEquals(5, friendships.getFriendsList("Joe").size(), "Joe ma pięcioro przyjaciół");
        Assert.assertTrue(friendships.areFriends("Joe", "Paul"), "Joe i Paul są przyjaciółmi");
        Assert.assertFalse(friendships.areFriends("Joe", "Ralph"), "Joe i Ralph nie są przyjaciółmi");

        List<String> friendsOfJoe = Arrays.asList("Audrey", "Peter", "Michael", "Britney", "Paul");
        Assert.assertTrue(friendships.getFriendsList("Joe").containsAll(friendsOfJoe));
    }
}
