const express = require('express')
const expressHandlebars = require('express-handlebars')

const app = express()

// konfiguracja silnika widoków Handlebars
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

const port = process.env.PORT || 3000

app.use(express.static(__dirname + '/public'))

const autoViews = {}
const fs = require('fs')
const { promisify } = require('util')
const fileExists = promisify(fs.exists)

app.use(async (req, res, next) => {
  const path = req.path.toLowerCase()
  // sprawdzamy pamięć podręczną; jeśli zawiera widok renderujemy go
  if(autoViews[path]) return res.render(autoViews[path])
  // jeśli pamięć podręczna nie zawiera widoku, sprawdzamy, czy istnieje
  // pasujący plik .handlebars
  if(await fileExists(__dirname + '/views' + path + '.handlebars')) {
    autoViews[path] = path.replace(/^\//, '')
    return res.render(autoViews[path])
  }
  // nie znaleziono widoku; przechodzimy do funkcji obsługi błędu 404 
  next()
})

app.listen(port, () => {
  console.log( `Express został uruchomiony pod adresem http://localhost:${port}` +
    '; naciśnij Ctrl-C, aby zakończyć.' )
})
