const nodemailer = require('nodemailer')

const credentials = require('./credentials')

const mailTransport = nodemailer.createTransport({
  host: 'smtp.sendgrid.net',
  auth: {
    user: credentials.sendgrid.user,
    pass: credentials.sendgrid.password,
  },
})

async function go() {
  const largeRecipientList = new Array(2000).fill().map((_, idx) => `customer${idx}@nowhere.com`)
  // largeRecipientList jest tablicą z adresami e-mail
  const recipientLimit = 100
  const batches = largeRecipientList.reduce((batches, r) => {
    const lastBatch = batches[batches.length - 1]
    if(lastBatch.length < recipientLimit)
      lastBatch.push(r)
    else
      batches.push([r])
    return batches
  }, [[]])
  try {
    const results = await Promise.all(batches.map(batch =>
      mailTransport.sendMail({
        from: '"Meadowlark Travel", <info@meadowlarktravel.com>',
        to: batch.join(', '),
        subject: 'Specjalna cena pakietu podróży do Hood River!',
        text: 'Zarezerwuj już teraz wycieczkę do malowniczej Hood River!',
      })
    ))
    console.log(results)
  } catch(err) {
    console.log('co najmniej jedna paczka wiadomości nie została dostarczona: ' + err.message)
  }
}

go()
