const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// poniższy układ nie ma pliku układu, a zatem plik
// views/no-layout.handlebars musi zawierać cały potrzebny kod HTML
app.get('/no-layout', (req, res) =>
  res.render('no-layout', { layout: null })
)

app.get('*', (req, res) => res.send('Sprawdź stronę "<a href="/no-layout">bez układut</a>"!'))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}/no-layout\n`))
