const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// plik views/error.hbs zawiera kod tego widoku
app.get('/error', (req, res) => res.status(500).render('error'))

app.get('*', (req, res) => res.send('Sprawdź naszą stronę <a href="/error">error</a> błędu!'))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}/error\n`))
