from model.explorer import Explorer

# sztuczne dane, które w rodziale dziesiątym zostaną zastąpione prawdziwą bazą SQL
_explorers = [
    Explorer(name="Claude Hande",
             country="FR",
             description="Rzadkie podczas pełni księżyca"),
    Explorer(name="Noah Weiser",
             country="DE",
             description="Krótkowzroczny mężczyzna z maczetą"),
    ]

def get_all() -> list[Explorer]:
    """Zwróć wszystkich odkrywców"""
    return _explorers

def get_one(name: str) -> Explorer | None:
    for _explorer in _explorers:
        if _explorer.name == name:
            return _explorer
    return None

# Poniższe funkcje są na razie niefunkcjonalne,
# więc działają bez faktycznego modyfikowanie
# listy _explorers
def create(explorer: Explorer) -> Explorer:
    """Dodaj nowego odkrywcę"""
    return explorer

def modify(explorer: Explorer) -> Explorer:
    """Częściowo zmodifikuj odkrywcę"""
    return explorer

def replace(explorer: Explorer) -> Explorer:
    """Zastąp całkowicie odkrywcę"""
    return explorer

def delete(name: str) -> bool:
    """Usuń odkrywcę, zróć None, jeśli znaleziono."""
    return None
