from pathlib import Path
from typing import Generator
from fastapi import FastAPI
from fastapi.responses import StreamingResponse

app = FastAPI()

def gen_file(path: str) -> Generator:
    with open(file=path, mode="rb") as file:
        yield file.read()

@app.get("/download_big/{name}")
async def download_big_file(name:str):
    gen_expr = gen_file(Path(path))
    response = StreamingResponse(
        content=gen_expr,
        status_code=200,
    )
    return response
