import nltk
from nltk.tokenize import word_tokenize
from nltk.corpus import stopwords
from textblob import TextBlob
from textblob.base import BaseTokenizer

# Lista polskich stop words
stopwords = set(stopwords.words('polish')) # Patrz uwagi w książce (wymaga konfiguracji)

class PolishTokenizer(BaseTokenizer):
    def tokenize(self, text):
        return [word for word in word_tokenize(text, language='polish') if word.lower() not in stopwords]

text = "To jest przykładowy tekst do analizy sentymentu."

blob = TextBlob(text, tokenizer=PolishTokenizer())

sentiment_score = blob.sentiment.polarity

if sentiment_score > 0:
    print("Pozytywny")
elif sentiment_score < 0:
    print("Negatywny")
else:
    print("Neutralny")