import spacy

#spacy.cli.download("pl_core_news_lg") # Patrz "Instalacja i konfiguracja spaCy" (dotyczy Pycharm)

import warnings
warnings.filterwarnings("ignore", category=UserWarning)

text = ("""Pierwsza tura wyborów prezydenckich w 2005 roku była pełna niespodzianek. 
W rządzonej przez Lecha Kaczyńskiego stolicy wyborcy chętniej głosowali na Donalda Tuska.
Finalna przegrana Donalda Tuska w wyborach prezydenckich z Lechem Kaczyńskim na zawsze
 zmieniła polską scenę polityczną.""")

nlp = spacy.load("pl_core_news_lg")
doc = nlp(text)

print ("Tekst do analizy:\n", text)
print ("Analiza NER - język polski:")
print(".----------------------------------------------.")
print("Jednostka NER         | Etykieta  |  Objaśnienie")
print(".----------------------------------------------.")
for ent in doc.ents:
    print(f"{ent.text:22} {ent.label_:12} {str(spacy.explain(ent.label_))}")