import pandas as pd
from sklearn.preprocessing import StandardScaler, MinMaxScaler

dane = {
    'zarobki': [10000, 360000, 32000, 5000, 6000, 23000, 12000, 120000],
    'wiek':    [32,    55,     60,    18,   25,   40,    60,    45],
    'wzrost':  [180,   156,    150,   185,  200,  190,   168,   190]
}

df = pd.DataFrame(dane)  # Tworzenie tabeli Pandas

std_scaler = StandardScaler()
scaled_data = std_scaler.fit_transform(df)
scaled_df = pd.DataFrame(scaled_data, columns=df.columns)

min_max_scaler = MinMaxScaler()
normalized_data = min_max_scaler.fit_transform(df)
normalized_df = pd.DataFrame(normalized_data, columns=df.columns)

cdf = pd.concat([df, scaled_df.add_suffix('_std'), normalized_df.add_suffix('_norm')], axis=1)
print(cdf)

cdf.to_excel('norm_stand.xlsx', index=False)
statystyki = cdf.describe()
statystyki.to_csv('description_stats.csv')

print("Po standardyzacji min-max [0,1]:")
print(f"  - Średnia dla: 'wiek': {cdf['wiek_norm'].mean():.2f}, 'zarobki': {cdf['zarobki_norm'].mean():.2f}, 'wzrost': {cdf['wzrost_norm'].mean():.2f}")
print(f"  - Odchylenie standardowe: 'wiek': {cdf['wiek_norm'].std():.2f}, 'zarobki': {cdf['zarobki_norm'].std():.2f}, 'wzrost': {cdf['wzrost_std'].std():.2f}")
print("Po normalizacji:")

print(f"  - Średnia dla: 'wiek': {cdf['wiek_std'].mean():.2f}, 'zarobki': {cdf['zarobki_std'].mean():.2f}, 'wzrost': {cdf['wzrost_std'].mean():.2f}")
print(f"  - Odchylenie standardowe: 'wiek': {cdf['wiek_std'].std():.2f}, 'zarobki': {cdf['zarobki_std'].std():.2f}, 'wzrost': {cdf['wzrost_std'].std():.2f}")
