import pandas as pd
from kmodes.kprototypes import KPrototypes
import matplotlib.pyplot as plt

data = pd.read_excel('ankieta-gracze-wiek.xlsx')
print(data.head(10))

cost = []
K = range(1, 11)
for num_clusters in K:
    kproto = KPrototypes(n_clusters=num_clusters, init="Cao", n_init=15, verbose=0)
    kproto.fit_predict(data, categorical=[1, 2, 3])
    cost.append(kproto.cost_)

plt.plot(K, cost, 'go-')
plt.xlabel('Liczba klastrów')
plt.ylabel('Koszt')
plt.title('Metoda Elbow')
plt.show()
k = 3
print("Wybrana liczba klastrów:", k)

kproto = KPrototypes(n_clusters=k, init="Cao", n_init=15, verbose=0)
clusters = kproto.fit_predict(data, categorical=[1, 2, 3])

data["Klaster"] = clusters
data.to_excel("ankieta-gracze-wiek-wyniki.xlsx", index=False)
