import numpy as np
from matplotlib import pyplot as plt

osX = np.array([10, -20,  -30, 20, 34, 45, 60, 70, 90, 100])
osY = np.array([5,  -5.6,  -8,  9, 11, 20, 10, 12, 10, 9.5])

posortowane_indeksy = np.argsort(osX)

x_sort = osX[posortowane_indeksy]
y_sort = osY[posortowane_indeksy]

plt.scatter(x_sort, y_sort, color='grey', s=50)

plt.plot( x_sort,  y_sort,
         marker='*',
         linestyle='--',
         color='k',
         ms=10,
         linewidth = '1')

plt.axhline(0, color='c', linestyle='--')
plt.axvline(0, color='g', linestyle='--')
plt.show()