
import pandas as pd
import matplotlib.pyplot as plt

# W systemie Windows użyj następującego formatu ścieżki: r"Inne\’nazwa pliku’.csv"
sprzedaz = pd.read_csv("Inne/dane3.csv", delimiter="|", decimal=",")
sprzedaz.info()
srednia = sprzedaz["Cena"].mean()
mediana = sprzedaz["Cena"].median()
moda    = sprzedaz["Cena"].mode()[0]

# Dokładamy 3 dodatkowe kolumny
sprzedaz["Średnia"] = srednia
sprzedaz["Mediana"] = mediana
sprzedaz["Moda"]    = moda


sprzedaz['Data'] = pd.to_datetime(sprzedaz['Data']) # Konwersja kolumny 'Data' na Pythonowy typ datetime

# Wydruk kontrolny (konsola)
print("Średnia=", srednia)
print("Mediana=", mediana)
print("Moda=",    moda)
print("Długość zaimportowanej serii danych:", len(sprzedaz))
print("Czy są puste wartości?\n", sprzedaz.isnull().sum())
print("Unikalne wartości wykryte w kolumnie 'Kolor': ", sprzedaz["Kolor"].unique())

print(sprzedaz)

# Konfiguracja stylu linii wykresu
plt.plot(sprzedaz['Data'], sprzedaz['Cena'],    marker='o', linestyle='-', label='Cena')
plt.plot(sprzedaz['Data'], sprzedaz['Średnia'], marker='D', linestyle='--', label='Średnia')
plt.plot(sprzedaz['Data'], sprzedaz['Moda'],    marker='.', linestyle='-', label='Moda')
plt.plot(sprzedaz['Data'], sprzedaz['Mediana'], marker='x', linestyle='-', label='Mediana')

# Konfiguracja etykiet i legendy
plt.title('Analiza sprzedaży')
plt.xlabel('Data')
plt.ylabel('Cena')
plt.grid(True)
plt.legend()

plt.xticks(rotation=45) # Rotacja etykietdla lepszej czytelności

plt.tight_layout()
plt.show() # Wyświetlenie wykresu





