import nltk
from nltk import pos_tag, ne_chunk
from nltk.tokenize import word_tokenize
text = ("""We spent 2 weeks in N.Y. in June 2024. During our stay John Biden visited
 one of local primary schools
located close to our hotel and all the roads were totally blocked""")

tokens=word_tokenize(text)
tags = pos_tag(tokens)
wyniki = ne_chunk(tags)

print ("Analiza NER w NLTK:")
print(".----------------------------.")
print("  Jednostka NER   |   Etykieta")
print(".----------------------- ----.")
for poddrzewo in wyniki:
    if isinstance(poddrzewo, nltk.Tree):
        entity = " ".join([word for word, tag in poddrzewo.leaves()])
        print(f" {entity:17}|{poddrzewo.label():13}")