import pandas as pd
from kmodes.kmodes import KModes
import matplotlib.pyplot as plt
data = pd.read_excel('ankieta-gracze.xlsx')
X = data.values
print(data.head(10))

cost = []
K = range(1, 11)
for num_clusters in K:
    kmode = KModes(n_clusters=num_clusters, init="Huang", n_init=15, verbose=0)
    kmode.fit_predict(data)
    cost.append(kmode.cost_)

plt.plot(K, cost, 'go-')
plt.xlabel('Liczba klastrów')
plt.ylabel('Koszt')
plt.title("'Metoda \"łokcia\"")
plt.show()
k = 4
print("Wybrana liczba klastrów:", k)

kmode = KModes(n_clusters=k, init="Huang", n_init=15, verbose=0)
clusters = kmode.fit_predict(data)

data["Klaster"] = clusters
data.to_excel("ankieta-gracze-wyniki.xlsx", index=False)