#
# Testy historyczne bazujące na zdarzeniach
# -- klasa bazowa (1)
#
# (c) Dr Yves J. Hilpisch
# Sztuczna inteligencja w finansach
#


class BacktestingBase:
    def __init__(self, env, model, amount, ptc, ftc, verbose=False):
        self.env = env  # <1>
        self.model = model  # <2>
        self.initial_amount = amount  # <3>
        self.current_balance = amount  # <3>
        self.ptc = ptc   # <4>
        self.ftc = ftc   # <5>
        self.verbose = verbose  # <6>
        self.units = 0  # <7>
        self.trades = 0  # <8>

    def get_date_price(self, bar):
        ''' Zwraca datę i cenę dla danego słupka.
        '''
        date = str(self.env.data.index[bar])[:10]  # <9>
        price = self.env.data[self.env.symbol].iloc[bar]  # <10>
        return date, price

    def print_balance(self, bar):
        ''' Wyświetla aktualny stan gotówki dla danego słupka.
        '''
        date, price = self.get_date_price(bar)
        print(f'{date} | stan gotówki = {self.current_balance:.2f}')  # <11>

    def calculate_net_wealth(self, price):
        return self.current_balance + self.units * price  # <12>

    def print_net_wealth(self, bar):
        ''' Wyświetla majątek netto dla danego słupka
            (gotówkę + wartość pozycji).
        '''
        date, price = self.get_date_price(bar)
        net_wealth = self.calculate_net_wealth(price)
        print(f'{date} | majątek netto = {net_wealth:.2f}')  # <13>

    def place_buy_order(self, bar, amount=None, units=None):
        ''' Składa zlecenie kupna dla danego słupka 
            z określoną kwotą lub liczbą jednostek.
        '''
        date, price = self.get_date_price(bar)
        if units is None:
            units = int(amount / price)  # <14>
            # units = amount / price  # <14>
        self.current_balance -= (1 + self.ptc) * \
            units * price + self.ftc  # <15>
        self.units += units  # <16>
        self.trades += 1  # <17>
        if self.verbose:
            print(f'{date} | kupno {units} jednostek po {price:.4f}')
            self.print_balance(bar)

    def place_sell_order(self, bar, amount=None, units=None):
        ''' Składa zlecenie sprzedaży dla danego słupka
            z określoną kwotą lub liczbą jednostek.
        '''
        date, price = self.get_date_price(bar)
        if units is None:
            units = int(amount / price)  # <14>
            # units = amount / price  # <14>
        self.current_balance += (1 - self.ptc) * \
            units * price - self.ftc  # <15>
        self.units -= units  # <16>
        self.trades += 1  # <17>
        if self.verbose:
            print(f'{date} | sprzedaż {units} jednostek po {price:.4f}')
            self.print_balance(bar)

    def close_out(self, bar):
        ''' Zamknięcie otwartej pozycji w danym słupku.
        '''
        date, price = self.get_date_price(bar)
        print(50 * '=')
        print(f'{date} | *** ZAMKNIĘCIE POZYCJI ***')
        if self.units < 0:
            self.place_buy_order(bar, units=-self.units)  # <18>
        else:
            self.place_sell_order(bar, units=self.units)  # <19>
        if not self.verbose:
            print(f'{date} | stan gotówki = {self.current_balance:.2f}')
        perf = (self.current_balance / self.initial_amount - 1) * 100  # <20>
        print(f'{date} | wynik netto [%] = {perf:.4f}')
        print(f'{date} | liczba transakcji [#] = {self.trades}')
        print(50 * '=')
